<?php
header('Content-Type: text/html; charset=UTF-8');
date_default_timezone_set('America/Asuncion');
$TZ_OFFSET  = date('P');                      // ej. "-03:00"
$SERVER_NOW = round(microtime(true) * 1000);  // epoch ms
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Usuarios Creados</title>
  <style>
    /* Fondo general */
    body{font-family:Arial, sans-serif;background:#000;color:#fff;margin:0;padding:0;user-select:none;}
    .card{max-width:800px;margin:20px auto;background:rgba(255,255,255,.1);padding:20px;border-radius:10px;box-shadow:0 4px 6px rgba(0,0,0,.3);}
    .card h1{text-align:center;font-size:24px;margin:0 0 20px;}
    /* Botones de filtro */
    .filter-buttons{display:flex;justify-content:center;gap:10px;margin-bottom:15px;flex-wrap:wrap;}
    .filter-buttons button{background:#222;color:#fff;border:1px solid #fff;border-radius:5px;padding:8px 14px;cursor:pointer;}
    .filter-buttons button.activo,.filter-buttons button:hover{background:#555;}
    /* Búsqueda */
    #buscarCorreo{width:100%;padding:10px;margin-bottom:20px;border:1px solid #fff;border-radius:5px;background:#222;color:#fff;}
    /* Usuarios */
    .usuario{padding:15px;border-bottom:1px solid #fff;}
    .usuario p{margin:5px 0;}
    /* Menú contextual */
    .menu-contextual{position:absolute;z-index:1000;background:#333;color:#fff;padding:20px;border-radius:5px;box-shadow:0 2px 5px rgba(0,0,0,.5);font-size:16px;}
    .menu-contextual button{display:block;width:100%;background:none;border:none;color:#fff;text-align:left;padding:10px 15px;font-size:18px;cursor:pointer;}
    .menu-contextual button:hover{background:#555;}
    @media(max-width:600px){
      .card{padding:10px;}
      .usuario p{font-size:16px;}
      .menu-contextual{font-size:18px;padding:15px;}
      .menu-contextual button{font-size:20px;padding:15px 20px;}
    }
  </style>
</head>
<body>
  <div class="card">
    <h1>Usuarios Creados</h1>

    <!-- Filtros -->
    <div class="filter-buttons">
      <button class="filtro activo" data-estado="todos">Todos</button>
      <button class="filtro"       data-estado="activo">Activos</button>
      <button class="filtro"       data-estado="por-vencer">Por vencer</button>
      <button class="filtro"       data-estado="vencido">Vencidos</button>
    </div>

    <!-- Buscador -->
    <input
      type="text"
      id="buscarCorreo"
      placeholder="Buscar por correo electr&oacute;nico"
    >

    <!-- Listado -->
    <div id="listaUsuarios"></div>
  </div>

  <script type="module">
    // ----------  Zona horaria y tiempo actual  ----------
    const TZ_OFFSET  = "<?php echo $TZ_OFFSET; ?>";     // ej. "-03:00"
    const SERVER_NOW = <?php echo $SERVER_NOW; ?>;      // epoch ms

    // ----------  Firebase  ----------
    import { initializeApp }           from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
    import { getAuth, onAuthStateChanged, sendPasswordResetEmail }
           from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
    import { getDatabase, ref, get, update, remove }
           from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

    const firebaseConfig = {
      apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
      authDomain: "magmaplus-32a56.firebaseapp.com",
      databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
      projectId: "magmaplus-32a56",
      storageBucket: "magmaplus-32a56.firebasestorage.app",
      messagingSenderId: "887768250224",
      appId: "1:63456783638:android:1e18d5484b58fc1411f437"
    };

    const app      = initializeApp(firebaseConfig);
    const auth     = getAuth(app);
    const database = getDatabase(app);

    // ----------  DOM refs  ----------
    const listaUsuarios = document.getElementById("listaUsuarios");
    const buscarCorreo  = document.getElementById("buscarCorreo");

    // ----------  Helpers fechas  ----------
    function strToTimestampPY(str){
      try{
        const limpio = str.replace(",","").trim();                 // dd/mm/yyyy HH:mm:ss
        const [d,m,yrHr] = limpio.split("/");
        const [y,hr] = yrHr.split(" ");
        const iso = `${y}-${m}-${d}T${hr}${TZ_OFFSET}`;
        const date = new Date(iso);
        return isNaN(date)?null:date.getTime();
      }catch{
        return null;
      }
    }
    function tsToStrPY(ts){
      return new Date(ts).toLocaleString("es-PY", {
        timeZone:"America/Asuncion",
        year:"numeric", month:"2-digit", day:"2-digit",
        hour:"2-digit", minute:"2-digit", second:"2-digit"
      }).replace(/\u200E/g,"");
    }

    // ----------  Estado filtros  ----------
    let filtroEstado = "todos";
    document.querySelectorAll(".filtro").forEach(b => {
      b.onclick = () => {
        document.querySelectorAll(".filtro").forEach(x => x.classList.remove("activo"));
        b.classList.add("activo");
        filtroEstado = b.dataset.estado;
        aplicarFiltro();
      };
    });
    buscarCorreo.oninput = aplicarFiltro;
    function aplicarFiltro(){
      const texto = buscarCorreo.value.toLowerCase();
      document.querySelectorAll(".usuario").forEach(u => {
        const matchCorreo = u.dataset.email.includes(texto);
        const matchEstado = filtroEstado === "todos" || u.dataset.estado === filtroEstado;
        u.style.display = (matchCorreo && matchEstado) ? "" : "none";
      });
    }

    // ----------  Autenticación y carga  ----------
    let adminUID = null;
    onAuthStateChanged(auth, user => {
      if (!user) {
        alert("No estas autenticado");
        location.href = "index.html";
        return;
      }
      adminUID = user.uid;
      cargarUsuarios();
    });

    async function cargarUsuarios(){
      if (!adminUID) return;
      listaUsuarios.textContent = "Cargando…";
      try {
        const snap = await get(ref(database, "usuarios"));
        listaUsuarios.innerHTML = "";
        if (!snap.exists()) {
          listaUsuarios.textContent = "No hay usuarios.";
          return;
        }

        const now = SERVER_NOW, tresDias = 3 * 24 * 60 * 60 * 1000;
        Object.entries(snap.val()).forEach(([uid, u]) => {
          if (u.idv !== adminUID || !u.email) return;

          const vtoTS = strToTimestampPY(u.benzymyentou || "");
          let estado = "indef";
          if (vtoTS !== null) {
            const diff = vtoTS - now;
            estado = diff < 0 ? "vencido" : diff <= tresDias ? "por-vencer" : "activo";
          }

          const div = document.createElement("div");
          div.className = "usuario";
          div.dataset.email = u.email.toLowerCase();
          div.dataset.estado = estado;
          div.innerHTML = `
            <p>Correo: ${u.email}</p>
            <p>Vencimiento: ${vtoTS ? tsToStrPY(vtoTS) : "Fecha invalida"}</p>
            <p>Contrase&ntilde;a: ${u.password || "&mdash;"}</p>
            <p>Creaci&oacute;n: ${u.creacion || "&mdash;"}</p>
            <hr />
          `;
          div.oncontextmenu = e => mostrarOpciones(e, uid, u);
          listaUsuarios.appendChild(div);
        });

        if (!listaUsuarios.children.length) {
          listaUsuarios.textContent = "No se encontraron usuarios para este Admin.";
        }
        aplicarFiltro();
      } catch(err) {
        console.error(err);
        listaUsuarios.textContent = "Error al cargar usuarios.";
      }
    }

    // ------------------------------------------------
    //  MENÚ CONTEXTUAL & ACCIONES
    // ------------------------------------------------
    function mostrarOpciones(ev, uid, u){
      ev.preventDefault();
      document.querySelectorAll(".menu-contextual").forEach(m => m.remove());

      const menu = document.createElement("div");
      menu.className = "menu-contextual";
      menu.innerHTML = `
        <button onclick="renovarCuenta('${uid}','${u.benzymyentou||""}')">Renovar cuenta</button>
        <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
        <button onclick="copiarUsuario('${u.email}','${u.password}')">Copiar usuario</button>
        <button onclick="eliminarCuenta('${uid}')">Eliminar cuenta</button>
        <button onclick="cambiarNumeroDispositivo('${uid}')">Cambiar numero de dispositivos</button>
        <button onclick="cambiarContrasena('${uid}')">Cambiar contraseña</button>

      `;
      document.body.appendChild(menu);
      menu.style.top  = `${ev.clientY}px`;
      menu.style.left = `${ev.clientX}px`;
      document.addEventListener("click", () => menu.remove(), { once: true });
    }

    // --- helpers Firebase límite ---
    async function verificarLimiteDisponible(){
      if (!adminUID) return false;
      try {
        const snap = await get(ref(database, `Superadmin/${adminUID}`));
        if (!snap.exists()) return false;
        return parseInt(snap.val().limiteUsuarios||"0",10) > 0;
      } catch {
        return false;
      }
    }
    async function actualizarLimiteUsuarios(){
      if (!adminUID) return false;
      try {
        const adminRef = ref(database, `Superadmin/${adminUID}`);
        const snap = await get(adminRef);
        if (!snap.exists()) return false;
        let lim = parseInt(snap.val().limiteUsuarios||"0",10);
        if (lim <= 0) return false;
        lim--;
        await update(adminRef, { limiteUsuarios: lim });
        return true;
      } catch {
        return false;
      }
    }

    // --------  ACCIONES DEL MENÚ  --------
    async function renovarCuenta(uid, vtoStr){
      if (!await verificarLimiteDisponible()) {
        alert("No tienes creditos para renovar.");
        return;
      }
      const ts = strToTimestampPY(vtoStr);
      if (ts === null) {
        alert("Fecha de vencimiento invalida");
        return;
      }
      const now = SERVER_NOW;
      const base = now > ts ? new Date(now) : new Date(ts);
      base.setMonth(base.getMonth() + 1);
      const nueva = tsToStrPY(base.getTime()).replace(",","");

      if (!await actualizarLimiteUsuarios()) {
        alert("No se pudo actualizar el limite");
        return;
      }
      await update(ref(database, `usuarios/${uid}`), { benzymyentou: nueva });
      alert(`Cuenta renovada: ${nueva}`);
      cargarUsuarios();
    }

    async function eliminarDeviceID(uid){
      await remove(ref(database, `usuarios/${uid}/deviceID`));
      alert("Device ID eliminado.");
      cargarUsuarios();
    }
    function copiarUsuario(email,pw){
      navigator.clipboard.writeText(`Correo: ${email} Contraseña: ${pw}`)
        .then(()=>alert("Copiado al portapapeles."))
        .catch(()=>alert("No se pudo copiar."));
    }
    async function eliminarCuenta(uid){
      if (!confirm("¿Eliminar la cuenta (solo email)?")) return;
      await remove(ref(database, `usuarios/${uid}/email`));
      alert("Email eliminado.");
      cargarUsuarios();
    }
    async function cambiarNumeroDispositivo(uid){
      const snap = await get(ref(database, `usuarios/${uid}`));
      if (!snap.exists()) { alert("No encontrado."); return; }
      const act = snap.val().maxDevices || 0;
      let n = prompt(`Actual: ${act}. Ingresa nuevo (m\u00e1x.3):`, act);
      if (n===null) return;
      n = parseInt(n,10);
      if (isNaN(n)||n<act||n>3) { alert("Valor inv\u00e1lido"); return; }
      await update(ref(database, `usuarios/${uid}`), { maxDevices: n });
      alert("Numero de dispositivos actualizado.");
      cargarUsuarios();
    }

    // -------- MODIFICACIÓN: CAMBIAR CONTRASEÑA REAL CON FIREBASE ADMIN  --------
    async function cambiarContrasena(uid){
      // Primero obtenemos el snapshot para tomar la contraseña actual (opcional, sólo para prompt):
      const snap = await get(ref(database, `usuarios/${uid}`));
      if (!snap.exists()) {
        alert("No encontrado.");
        return;
      }
      const act = snap.val().password || "";
      let nueva = prompt("Contraseña nueva:", act);
      if (nueva === null || !nueva.trim()) {
        alert("Contraseña inválida.");
        return;
      }
      nueva = nueva.trim();
      try {
        // Llamamos a tu endpoint de Firebase Admin
        const response = await fetch("/api/changePassword", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ uid, newPassword: nueva })
        });
        const data = await response.json();
        if (!data.success) {
          throw new Error(data.error || "Error al cambiar contraseña");
        }
        // Si quieres seguir guardando la contraseña en Realtime Database:
        await update(ref(database, `usuarios/${uid}`), { password: nueva });
        alert("Contraseña cambiada correctamente.");
        cargarUsuarios();
      } catch(err) {
        console.error(err);
        alert("Error al cambiar contraseña: " + (err.message || "Sin descripción"));
      }
    }
    // ---------------------------------------------------------------------------------

    async function restablecerContrasena(email){
      if (!email) { alert("Sin email registrado"); return; }
      try {
        await sendPasswordResetEmail(auth, email);
        alert(`Se envi\u00f3 enlace de restablecimiento a ${email}`);
      } catch {
        alert("Error al enviar email.");
      }
    }

    // --- Exponer globales para inline handlers ---
    Object.assign(window, {
      renovarCuenta,
      eliminarDeviceID,
      copiarUsuario,
      eliminarCuenta,
      cambiarNumeroDispositivo,
      cambiarContrasena,
      restablecerContrasena
    });
  </script>
</body>
</html>
