import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import {
  getAuth,
  onAuthStateChanged,
  sendPasswordResetEmail                     // ← NUEVO
} from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
import { getDatabase, ref, get, update, remove } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

// Configuración de Firebase
const firebaseConfig = {
    apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
    authDomain: "magmaplus-32a56.firebaseapp.com",
    databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
    projectId: "magmaplus-32a56",
    storageBucket: "magmaplus-32a56.firebasestorage.app",
    messagingSenderId: "887768250224",
    appId: "1:63456783638:android:1e18d5484b58fc1411f437"
};

const app = initializeApp(firebaseConfig);
const auth = getAuth(app);
const database = getDatabase(app);

const listaUsuarios = document.getElementById("listaUsuarios");
const buscarCorreo = document.getElementById("buscarCorreo");

// Guardaremos aquí el UID del admin
let adminUID = null;

// Verificar si el administrador está autenticado
onAuthStateChanged(auth, (user) => {
  if (user) {
    adminUID = user.uid; 
    console.log("Administrador autenticado:", adminUID);

    // Ya que se autenticó, cargamos los usuarios
    cargarUsuarios();
  } else {
    alert("No estás autenticado. Redirigiendo...");
    window.location.href = "index.html";
  }
});

// Verificar límite de usuarios disponibles
async function verificarLimiteDisponible() {
  if (!adminUID) {
    console.log("No hay adminUID todavía.");
    return false;
  }

  try {
    const adminRef = ref(database, `Superadmin/${adminUID}`);
    const snapshot = await get(adminRef);
    if (snapshot.exists()) {
      const adminData = snapshot.val();
      const limite = parseInt(adminData.limiteUsuarios, 10);
      console.log("Límite leído:", limite);
      return limite > 0;
    } else {
      console.log(`No se encontró Superadmin/${adminUID}`);
    }
    return false;
  } catch (error) {
    console.error("Error al verificar límite:", error);
    return false;
  }
}

// Actualizar límite de usuarios
async function actualizarLimiteUsuarios() {
  if (!adminUID) return false;

  try {
    const adminRef = ref(database, `Superadmin/${adminUID}`);
    const snapshot = await get(adminRef);

    if (snapshot.exists()) {
      const adminData = snapshot.val();
      let nuevoLimite = parseInt(adminData.limiteUsuarios, 10);
      console.log("Límite actual:", nuevoLimite);

      if (nuevoLimite > 0) {
        nuevoLimite--;
        await update(adminRef, { limiteUsuarios: nuevoLimite });
        console.log("Límite actualizado a:", nuevoLimite);
        return true;
      }
      console.log("El límite ya es 0. No se puede renovar.");
    } else {
      console.log(`No se encontró Superadmin/${adminUID}`);
    }
    return false;
  } catch (error) {
    console.error("Error al actualizar límite:", error);
    return false;
  }
}

// Función para convertir la fecha guardada al formato deseado
function convertirFecha(fechaStr) {
  try {
    const [dia, mes, anioHora] = fechaStr.split("/");
    const [anio, hora] = anioHora.split(" ");
    const fechaISO = `${anio}-${mes}-${dia}T${hora}`;
    const fecha = new Date(fechaISO);

    if (isNaN(fecha.getTime())) throw new Error("Formato inválido");

    return (
      `${fecha.getDate().toString().padStart(2, "0")}/` +
      `${(fecha.getMonth() + 1).toString().padStart(2, "0")}/` +
      `${fecha.getFullYear()} ` +
      `${fecha.getHours().toString().padStart(2, "0")}:` +
      `${fecha.getMinutes().toString().padStart(2, "0")}:` +
      `${fecha.getSeconds().toString().padStart(2, "0")}`
    );
  } catch {
    return null;
  }
}

// Cargar usuarios creados por este administrador (basado en idv)
async function cargarUsuarios() {
  if (!adminUID) return;

  try {
    const usuariosRef = ref(database, "usuarios");
    const snapshot = await get(usuariosRef);

    if (snapshot.exists()) {
      const usuarios = snapshot.val();
      listaUsuarios.innerHTML = "";

      for (const uid in usuarios) {
        const usuario = usuarios[uid];
        // Solo listamos si idv coincide con nuestro adminUID
        if (usuario.idv === adminUID && usuario.email) {
          const usuarioDiv = document.createElement("div");
          usuarioDiv.classList.add("usuario");

          const fechaCreacion = convertirFecha(usuario.creacion);
          const fechaVencimiento = convertirFecha(usuario.benzymyentou);

          usuarioDiv.innerHTML = `
            <p>Correo: ${usuario.email || "No disponible"}</p>
            <p>Vencimiento: ${fechaVencimiento || "Fecha inválida"}</p>
            <p>Contraseña: ${usuario.password}</p>
            <p>Creación: ${fechaCreacion || "Fecha inválida"}</p>
            <hr />
          `;
          usuarioDiv.addEventListener("contextmenu", (e) => mostrarOpciones(e, uid, usuario));
          listaUsuarios.appendChild(usuarioDiv);
        }
      }

      if (listaUsuarios.innerHTML === "") {
        listaUsuarios.innerHTML = "<p>No se encontraron usuarios para este Admin.</p>";
      }
    } else {
      listaUsuarios.innerHTML = "<p>No hay usuarios creados todavía.</p>";
    }
  } catch (error) {
    console.error("Error al cargar usuarios:", error);
    listaUsuarios.innerHTML = "<p>Error al cargar usuarios.</p>";
  }
}

// Mostrar el menú contextual al hacer clic derecho
function mostrarOpciones(event, uid, usuario) {
  event.preventDefault();

  // Quitar menús existentes
  const menusExistentes = document.querySelectorAll(".menu-contextual");
  menusExistentes.forEach((menu) => menu.remove());

  const menu = document.createElement("div");
  menu.classList.add("menu-contextual");
  menu.innerHTML = `
    <button onclick="renovarCuenta('${uid}', '${usuario.benzymyentou}')">Renovar Cuenta</button>
    <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
    <button onclick="copiarUsuario('${usuario.email}', '${usuario.password}')">Copiar Usuario Creado</button>
    <button onclick="eliminarCuenta('${uid}')">Eliminar Cuenta</button>
    <button onclick="cambiarNumeroDispositivo('${uid}')">Cambiar Número de Dispositivo</button>
    <button onclick="cambiarContrasena('${uid}')">Cambiar Contraseña</button>
    <button onclick="restablecerContrasena('${usuario.email}')">Restablecer Contraseña</button>  <!-- NUEVO -->
  `;
  document.body.appendChild(menu);

  menu.style.top = `${event.clientY}px`;
  menu.style.left = `${event.clientX}px`;

  document.addEventListener("click", () => menu.remove(), { once: true });
}

// ---------- NUEVO: RESTABLECER CONTRASEÑA ----------
async function restablecerContrasena(email) {
  if (!email) {
    alert("El usuario no tiene correo registrado.");
    return;
  }
  try {
    await sendPasswordResetEmail(auth, email);
    alert(`Se envió un correo de restablecimiento a ${email}.`);
  } catch (error) {
    console.error("Error al enviar correo:", error);
    alert("No se pudo enviar el correo. Intenta de nuevo.");
  }
}

// Función para renovar cuenta
async function renovarCuenta(uid, vencimientoActual) {
  console.log("Renovando cuenta para:", uid, "vencimientoActual:", vencimientoActual);

  // Verificar si hay créditos
  const tieneCreditos = await verificarLimiteDisponible();
  if (!tieneCreditos) {
    alert("No tienes créditos disponibles para renovar la cuenta");
    return;
  }

  try {
    // Limpiar fecha (quitar comas si las hay)
    const vencimientoLimpio = vencimientoActual.replace(",", "");
    const [dia, mes, anioHora] = vencimientoLimpio.split("/");
    const [anio, hora] = anioHora.split(" ");
    const fechaActual = new Date(`${anio}-${mes}-${dia}T${hora}`);

    if (isNaN(fechaActual.getTime())) {
      throw new Error("Fecha de vencimiento inválida.");
    }

    // Aumentar un mes
    fechaActual.setMonth(fechaActual.getMonth() + 1);

    // Nuevo formato
    const nuevaFecha = (
      fechaActual.getDate().toString().padStart(2, "0") + "/" +
      (fechaActual.getMonth() + 1).toString().padStart(2, "0") + "/" +
      fechaActual.getFullYear() + " " +
      fechaActual.getHours().toString().padStart(2, "0") + ":" +
      fechaActual.getMinutes().toString().padStart(2, "0") + ":" +
      fechaActual.getSeconds().toString().padStart(2, "0")
    );

    // Disminuir el crédito
    const limiteActualizado = await actualizarLimiteUsuarios();
    if (!limiteActualizado) {
      alert("No se pudo actualizar el límite de usuarios. Renovación cancelada.");
      return;
    }

    // Actualizar fecha de vencimiento
    const usuarioRef = ref(database, `usuarios/${uid}`);
    await update(usuarioRef, { benzymyentou: nuevaFecha });

    alert(`Cuenta renovada. Nuevo vencimiento: ${nuevaFecha}`);
    // Recargar la lista
    cargarUsuarios();
  } catch (error) {
    console.error("Error al renovar cuenta:", error.message);
    alert("No se pudo renovar la cuenta. Verifica el formato de la fecha.");
  }
}

// Función para eliminar Device ID
async function eliminarDeviceID(uid) {
  try {
    const deviceIDRef = ref(database, `usuarios/${uid}/deviceID`);
    await remove(deviceIDRef);

    alert("Device ID eliminado exitosamente.");
    cargarUsuarios();
  } catch (error) {
    console.error("Error al eliminar Device ID:", error);
    alert("No se pudo eliminar el Device ID. Intenta de nuevo.");
  }
}

// Copiar usuario
function copiarUsuario(email, password) {
  const texto = `Correo: ${email}\nContraseña: ${password}`;
  const textarea = document.createElement("textarea");
  textarea.value = texto;
  document.body.appendChild(textarea);
  textarea.select();

  if (document.execCommand("copy")) {
    alert("Usuario copiado al portapapeles.");
  } else {
    alert("Error al intentar copiar. Revisa permisos del portapapeles.");
  }

  document.body.removeChild(textarea);
}

// Eliminar cuenta
async function eliminarCuenta(uid) {
  if (
    confirm(
      "¿Estás seguro de que deseas eliminar la cuenta? Se borrará el email del usuario."
    )
  ) {
    try {
      const emailRef = ref(database, `usuarios/${uid}/email`);
      await remove(emailRef);

      alert("Cuenta eliminada. (Campo 'email' borrado)");
      cargarUsuarios();
    } catch (error) {
      console.error("Error al eliminar cuenta:", error);
      alert("No se pudo eliminar la cuenta. Intenta de nuevo.");
    }
  }
}

// Función para cambiar el número de dispositivos
async function cambiarNumeroDispositivo(uid) {
  try {
    const userRef = ref(database, `usuarios/${uid}`);
    const snapshot = await get(userRef);
    if (snapshot.exists()) {
      const userData = snapshot.val();
      const currentMaxDevices = userData.maxDevices || 0;
      let nuevoMaxDevices = prompt(
        `El número actual de dispositivos es ${currentMaxDevices}. Ingrese el nuevo número de dispositivos (máximo 3):`,
        currentMaxDevices
      );
      if (nuevoMaxDevices === null) return; // Si se cancela
      nuevoMaxDevices = parseInt(nuevoMaxDevices, 10);
      if (isNaN(nuevoMaxDevices)) {
        alert("Por favor, ingrese un número válido.");
        return;
      }
      if (nuevoMaxDevices > 3) {
        alert("El número máximo permitido es 3.");
        return;
      }
      if (nuevoMaxDevices < currentMaxDevices) {
        alert("El nuevo número debe ser mayor o igual al número actual.");
        return;
      }
      await update(userRef, { maxDevices: nuevoMaxDevices });
      alert(`Número de dispositivos actualizado a ${nuevoMaxDevices}.`);
      cargarUsuarios();
    } else {
      alert("Usuario no encontrado.");
    }
  } catch (error) {
    console.error("Error al cambiar número de dispositivo:", error);
    alert("Error al actualizar el número de dispositivos.");
  }
}

// Función para cambiar contraseña
async function cambiarContrasena(uid) {
  try {
    const userRef = ref(database, `usuarios/${uid}`);
    const snapshot = await get(userRef);
    if (snapshot.exists()) {
      const userData = snapshot.val();
      const currentPassword = userData.password;
      let nuevaPassword = prompt(
        `La contraseña actual es: ${currentPassword}\nIngrese la nueva contraseña:`,
        currentPassword
      );
      if (nuevaPassword === null) return; // Si se cancela
      if (nuevaPassword === "") {
        alert("La contraseña no puede estar vacía.");
        return;
      }
      await update(userRef, { password: nuevaPassword });
      alert("Contraseña actualizada.");
      cargarUsuarios();
    } else {
      alert("Usuario no encontrado.");
    }
  } catch (error) {
    console.error("Error al cambiar contraseña:", error);
    alert("Error al actualizar la contraseña.");
  }
}

// Hacer funciones globales
window.renovarCuenta = renovarCuenta;
window.eliminarDeviceID = eliminarDeviceID;
window.copiarUsuario = copiarUsuario;
window.eliminarCuenta = eliminarCuenta;
window.cambiarNumeroDispositivo = cambiarNumeroDispositivo;
window.cambiarContrasena = cambiarContrasena;
window.restablecerContrasena = restablecerContrasena;      // ← NUEVO

// Filtrar usuarios por correo electrónico
buscarCorreo.addEventListener("input", () => {
  const filtro = buscarCorreo.value.toLowerCase();
  const usuarios = document.querySelectorAll(".usuario");

  usuarios.forEach((usuario) => {
    const correo = usuario.querySelector("p:first-child").textContent.toLowerCase();
    usuario.style.display = correo.includes(filtro) ? "" : "none";
  });
});
