// ---------- IMPORTS ----------
import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import {
    getAuth,
    onAuthStateChanged,
    sendPasswordResetEmail               // ← NUEVO
} from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
import {
    getDatabase,
    ref,
    get,
    update,
    remove
} from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";


// ---------- CONFIGURACIÓN DE FIREBASE ----------
const firebaseConfig = {
    apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
    authDomain: "magmaplus-32a56.firebaseapp.com",
    databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
    projectId: "magmaplus-32a56",
    storageBucket: "magmaplus-32a56.firebasestorage.app",
    messagingSenderId: "887768250224",
    appId: "1:63456783638:android:1e18d5484b58fc1411f437"
};

const app = initializeApp(firebaseConfig);
const auth = getAuth(app);
const database = getDatabase(app);


// ---------- REFERENCIAS A ELEMENTOS DEL DOM ----------
const listaUsuarios = document.getElementById("listaUsuarios");
const buscarCorreo  = document.getElementById("buscarCorreo");

let adminUID = null;


// ---------- AUTENTICACIÓN DEL ADMIN ----------
onAuthStateChanged(auth, (user) => {
    if (user) {
        adminUID = user.uid;
        cargarUsuarios();
    } else {
        alert("No estás autenticado. Redirigiendo...");
        window.location.href = "index.html";
    }
});


// ---------- LÍMITE DE USUARIOS ----------
async function verificarLimiteDisponible() {
    if (!adminUID) return false;

    try {
        const adminRef = ref(database, `Admin/${adminUID}`);
        const snapshot = await get(adminRef);

        if (snapshot.exists()) {
            const adminData = snapshot.val();
            const limite = parseInt(adminData.limiteUsuarios, 10);
            return limite > 0;
        }
        return false;
    } catch (error) {
        console.error("Error al verificar límite:", error);
        return false;
    }
}

async function actualizarLimiteUsuarios() {
    if (!adminUID) return false;

    try {
        const adminRef = ref(database, `Admin/${adminUID}`);
        const snapshot = await get(adminRef);

        if (snapshot.exists()) {
            const adminData = snapshot.val();
            let nuevoLimite = parseInt(adminData.limiteUsuarios, 10);

            if (nuevoLimite > 0) {
                nuevoLimite--;
                await update(adminRef, { limiteUsuarios: nuevoLimite });
                return true;
            }
        }
        return false;
    } catch (error) {
        console.error("Error al actualizar límite:", error);
        return false;
    }
}


// ---------- UTIL: FORMATEAR FECHAS ----------
function convertirFecha(fechaStr) {
    try {
        const [dia, mes, anioHora] = fechaStr.split("/");
        const [anio, hora] = anioHora.split(" ");
        const fechaISO = `${anio}-${mes}-${dia}T${hora}`;
        const fecha = new Date(fechaISO);

        if (isNaN(fecha.getTime())) throw new Error("Formato inválido");

        return `${fecha.getDate().toString().padStart(2, "0")}/${(fecha.getMonth() + 1)
            .toString()
            .padStart(2, "0")}/${fecha.getFullYear()} ${fecha
            .getHours()
            .toString()
            .padStart(2, "0")}:${fecha.getMinutes().toString().padStart(2, "0")}:${fecha
            .getSeconds()
            .toString()
            .padStart(2, "0")}`;
    } catch {
        return null;
    }
}


// ---------- CARGAR USUARIOS ----------
async function cargarUsuarios() {
    const usuariosRef = ref(database, "usuarios");
    const snapshot = await get(usuariosRef);

    if (snapshot.exists()) {
        const usuarios = snapshot.val();
        listaUsuarios.innerHTML = "";

        for (const uid in usuarios) {
            const usuario = usuarios[uid];
            // Mostrar sólo los usuarios creados por este admin y que tengan correo
            if (usuario.idv === adminUID && usuario.email) {

                const usuarioDiv = document.createElement("div");
                usuarioDiv.classList.add("usuario");

                const fechaCreacion   = convertirFecha(usuario.creacion);
                const fechaVencimiento= convertirFecha(usuario.benzymyentou);

                usuarioDiv.innerHTML = `
                    <p>Correo: ${usuario.email || "No disponible"}</p>
                    <p>Vencimiento: ${fechaVencimiento || "Fecha inválida"}</p>
                    <p>Contraseña: ${usuario.password}</p>
                    <p>Creación: ${fechaCreacion || "Fecha inválida"}</p>
                    <hr />
                `;

                // Menú contextual al hacer clic derecho
                usuarioDiv.addEventListener("contextmenu", (e) =>
                    mostrarOpciones(e, uid, usuario)
                );
                listaUsuarios.appendChild(usuarioDiv);
            }
        }

        if (listaUsuarios.innerHTML === "") {
            listaUsuarios.innerHTML =
                "<p>No se encontraron usuarios con correo electrónico.</p>";
        }
    } else {
        listaUsuarios.innerHTML =
            "<p>No se encontraron usuarios creados por este administrador.</p>";
    }
}


// ---------- MENÚ CONTEXTUAL ----------
function mostrarOpciones(event, uid, usuario) {
    event.preventDefault();

    // Eliminar menús anteriores
    const menusExistentes = document.querySelectorAll(".menu-contextual");
    menusExistentes.forEach((menu) => menu.remove());

    // Crear menú
    const menu = document.createElement("div");
    menu.classList.add("menu-contextual");
    menu.innerHTML = `
        <button onclick="renovarCuenta('${uid}', '${usuario.benzymyentou}')">Renovar Cuenta</button>
        <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
        <button onclick="cambiarNumeroDispositivo('${uid}', '${usuario.maxDevices || 0}')">Cambiar Número de Dispositivo</button>
        <button onclick="cambiarContrasena('${uid}', '${usuario.password}')">Cambiar Contraseña</button>
        <button onclick="restablecerContrasena('${usuario.email}')">Restablecer Contraseña</button> <!-- NUEVO -->
        <button onclick="copiarUsuario('${usuario.email}', '${usuario.password}')">Copiar Usuario Creado</button>
        <button onclick="eliminarCuenta('${uid}')">Eliminar Cuenta</button>
    `;
    document.body.appendChild(menu);

    // Posicionar menú
    menu.style.top  = `${event.clientY}px`;
    menu.style.left = `${event.clientX}px`;

    // Cerrar menú al hacer clic fuera
    document.addEventListener("click", () => menu.remove(), { once: true });
}


// ---------- RESTABLECER CONTRASEÑA ----------
async function restablecerContrasena(email) {
    if (!email) {
        alert("El usuario no tiene un correo registrado.");
        return;
    }
    try {
        await sendPasswordResetEmail(auth, email);
        alert(`Se envió un correo de restablecimiento a: ${email}.`);
    } catch (error) {
        console.error("Error al enviar correo:", error);
        alert("No se pudo enviar el correo: " + (error.message || error));
    }
}


// ---------- RENOVAR CUENTA ----------
async function renovarCuenta(uid, vencimientoActual) {
    const tieneCreditos = await verificarLimiteDisponible();
    if (!tieneCreditos) {
        alert("No tienes créditos disponibles para renovar la cuenta.");
        return;
    }

    try {
        const vencimientoLimpio = vencimientoActual.replace(",", "");
        const [dia, mes, anioHora] = vencimientoLimpio.split("/");
        const [anio, hora] = anioHora.split(" ");
        const fechaActual = new Date(`${anio}-${mes}-${dia}T${hora}`);

        if (isNaN(fechaActual.getTime())) {
            throw new Error("Fecha de vencimiento inválida.");
        }

        // Sumar un mes
        fechaActual.setMonth(fechaActual.getMonth() + 1);

        const nuevaFecha = `${fechaActual.getDate().toString().padStart(2, "0")}/${(fechaActual.getMonth() + 1)
            .toString()
            .padStart(2, "0")}/${fechaActual.getFullYear()} ${fechaActual
            .getHours()
            .toString()
            .padStart(2, "0")}:${fechaActual.getMinutes().toString().padStart(2, "0")}:${fechaActual
            .getSeconds()
            .toString()
            .padStart(2, "0")}`;

        const limiteActualizado = await actualizarLimiteUsuarios();
        if (!limiteActualizado) {
            alert("No se pudo actualizar el límite de usuarios. La renovación ha sido cancelada.");
            return;
        }

        const usuarioRef = ref(database, `usuarios/${uid}`);
        await update(usuarioRef, { benzymyentou: nuevaFecha });

        alert(`Cuenta renovada. Nuevo vencimiento: ${nuevaFecha}`);
        cargarUsuarios();
    } catch (error) {
        console.error("Error al renovar cuenta:", error.message);
        alert("No se pudo renovar la cuenta. Verifica el formato de la fecha.");
    }
}


// ---------- ELIMINAR DEVICE ID ----------
async function eliminarDeviceID(uid) {
    try {
        const deviceIDRef = ref(database, `usuarios/${uid}/deviceID`);
        await remove(deviceIDRef);

        alert("Device ID eliminado exitosamente.");
        cargarUsuarios();
    } catch (error) {
        console.error("Error al eliminar Device ID:", error);
        alert("No se pudo eliminar el Device ID. Intenta de nuevo.");
    }
}


// ---------- CAMBIAR NÚMERO DE DISPOSITIVO ----------
async function cambiarNumeroDispositivo(uid, currentMaxDevices) {
    let currentDevices = parseInt(currentMaxDevices, 10);
    if (isNaN(currentDevices)) currentDevices = 0;

    const nuevoNumeroStr = prompt(
        `El número actual de dispositivos es ${currentDevices}.\nIngrese el nuevo número (máximo 3):`,
        currentDevices
    );
    if (nuevoNumeroStr === null) return;

    const nuevoNumero = parseInt(nuevoNumeroStr, 10);
    if (isNaN(nuevoNumero) || nuevoNumero < currentDevices || nuevoNumero > 3) {
        alert(`Número inválido. Debe ser entre ${currentDevices} y 3.`);
        return;
    }

    try {
        const usuarioRef = ref(database, `usuarios/${uid}`);
        await update(usuarioRef, { maxDevices: nuevoNumero });
        alert(`Número de dispositivo actualizado a ${nuevoNumero}`);
        cargarUsuarios();
    } catch (error) {
        console.error("Error al actualizar el número de dispositivo:", error);
        alert("No se pudo actualizar el número de dispositivo.");
    }
}


// ---------- CAMBIAR CONTRASEÑA ----------
async function cambiarContrasena(uid, currentPassword) {
    const nuevaPassword = prompt(
        `La contraseña actual es: ${currentPassword}.\nIngrese la nueva contraseña:`,
        currentPassword
    );
    if (nuevaPassword === null) return;

    if (nuevaPassword.trim() === "") {
        alert("La contraseña no puede estar vacía.");
        return;
    }

    try {
        const usuarioRef = ref(database, `usuarios/${uid}`);
        await update(usuarioRef, { password: nuevaPassword });
        alert("Contraseña actualizada correctamente.");
        cargarUsuarios();
    } catch (error) {
        console.error("Error al actualizar la contraseña:", error);
        alert("No se pudo actualizar la contraseña.");
    }
}


// ---------- COPIAR USUARIO ----------
function copiarUsuario(email, password) {
    const texto = `Correo: ${email}\nContraseña: ${password}`;
    const textarea = document.createElement("textarea");
    textarea.value = texto;
    document.body.appendChild(textarea);
    textarea.select();

    if (document.execCommand("copy")) {
        alert("Usuario copiado al portapapeles.");
    } else {
        alert("Error al intentar copiar el contenido. Asegúrese de que el navegador permita el acceso al portapapeles.");
    }

    document.body.removeChild(textarea);
}


// ---------- ELIMINAR CUENTA ----------
async function eliminarCuenta(uid) {
    if (
        confirm("¿Estás seguro de que deseas eliminar la cuenta? Esto eliminará el campo de correo electrónico del usuario.")
    ) {
        try {
            const emailRef = ref(database, `usuarios/${uid}/email`);
            await remove(emailRef);

            alert("Cuenta eliminada exitosamente (campo 'email' eliminado).");
            cargarUsuarios();
        } catch (error) {
            console.error("Error al eliminar cuenta:", error);
            alert("No se pudo eliminar la cuenta. Intenta de nuevo.");
        }
    }
}


// ---------- EXPONER FUNCIONES GLOBALMENTE ----------
window.renovarCuenta            = renovarCuenta;
window.eliminarDeviceID         = eliminarDeviceID;
window.cambiarNumeroDispositivo = cambiarNumeroDispositivo;
window.cambiarContrasena        = cambiarContrasena;
window.copiarUsuario            = copiarUsuario;
window.eliminarCuenta           = eliminarCuenta;
window.restablecerContrasena    = restablecerContrasena;    // ← NUEVO


// ---------- FILTRO POR CORREO ----------
buscarCorreo.addEventListener("input", () => {
    const filtro = buscarCorreo.value.toLowerCase();
    const usuarios = document.querySelectorAll(".usuario");

    usuarios.forEach((usuario) => {
        const correo = usuario
            .querySelector("p:first-child")
            .textContent.toLowerCase();
        usuario.style.display = correo.includes(filtro) ? "" : "none";
    });
});
