<?php
header('Content-Type: text/html; charset=UTF-8');
date_default_timezone_set('America/Asuncion');
$currentDate = date('Y-m-d\TH:i:s');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Usuarios Creados</title>
  <link rel="stylesheet" href="usuarios.css">
</head>
<body>
  <div class="background">
    <div class="shape"></div>
    <div class="shape"></div>
  </div>

  <div class="card">
    <h1>Usuarios Creados</h1>
    <input
      type="text"
      id="buscarCorreo"
      placeholder="Buscar por correo electr&oacute;nico"
    />
    <div id="listaUsuarios"></div>
  </div>

  <script type="module">
    // Fecha actual del servidor (Asuncin)
    const servidorFechaActual = new Date('<?php echo $currentDate; ?>');

    // ---------- IMPORTS ----------
    import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
    import {
      getAuth,
      onAuthStateChanged,
      sendPasswordResetEmail
    } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js";
    import {
      getDatabase,
      ref,
      get,
      update,
      remove
    } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

    // ---------- CONFIGURACI07N DE FIREBASE ----------
    const firebaseConfig = {
      apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
      authDomain: "magmaplus-32a56.firebaseapp.com",
      databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
      projectId: "magmaplus-32a56",
      storageBucket: "magmaplus-32a56.firebasestorage.app",
      messagingSenderId: "887768250224",
      appId: "1:63456783638:android:1e18d5484b58fc1411f437"
    };

    const app = initializeApp(firebaseConfig);
    const auth = getAuth(app);
    const database = getDatabase(app);

    // ---------- REFERENCIAS AL DOM ----------
    const listaUsuarios = document.getElementById("listaUsuarios");
    const buscarCorreo  = document.getElementById("buscarCorreo");
    let adminUID = null;

    // ---------- AUTENTICACI07N DEL ADMIN ----------
    onAuthStateChanged(auth, (user) => {
      if (user) {
        adminUID = user.uid;
        cargarUsuarios();
      } else {
        alert("No estas autenticado. Redirigiendo...");
        window.location.href = "index.html";
      }
    });

    // ---------- L01MITE DE USUARIOS ----------
    async function verificarLimiteDisponible() {
      if (!adminUID) return false;
      const snap = await get(ref(database, `Admin/${adminUID}`));
      if (snap.exists()) {
        const l = parseInt(snap.val().limiteUsuarios, 10);
        return l > 0;
      }
      return false;
    }
    async function actualizarLimiteUsuarios() {
      if (!adminUID) return false;
      const adminRef = ref(database, `Admin/${adminUID}`);
      const snap = await get(adminRef);
      if (snap.exists()) {
        let l = parseInt(snap.val().limiteUsuarios, 10);
        if (l > 0) {
          await update(adminRef, { limiteUsuarios: l - 1 });
          return true;
        }
      }
      return false;
    }

    // ---------- UTIL: FORMATEAR FECHAS ----------
    function convertirFecha(fechaStr) {
      try {
        const [dia, mes, anioHora] = fechaStr.split("/");
        const [anio, hora] = anioHora.split(" ");
        const f = new Date(`${anio}-${mes}-${dia}T${hora}`);
        return `${f.getDate().toString().padStart(2,"0")}/${(f.getMonth()+1).toString().padStart(2,"0")}/${f.getFullYear()} ${f.getHours().toString().padStart(2,"0")}:${f.getMinutes().toString().padStart(2,"0")}:${f.getSeconds().toString().padStart(2,"0")}`;
      } catch {
        return null;
      }
    }

    // ---------- CARGAR USUARIOS ----------
    async function cargarUsuarios() {
      const snap = await get(ref(database, "usuarios"));
      listaUsuarios.innerHTML = "";

      if (snap.exists()) {
        const usuarios = snap.val();
        for (const uid in usuarios) {
          const u = usuarios[uid];
          if (u.idv === adminUID && u.email) {
            const div = document.createElement("div");
            div.classList.add("usuario");
            const cre = convertirFecha(u.creacion);
            const ven = convertirFecha(u.benzymyentou);
            div.innerHTML = `
              <p>Correo: ${u.email}</p>
              <p>Vencimiento: ${ven || "Invalida"}</p>
              <p>Contrase&ntilde;a: ${u.password}</p>
              <p>Creaci&oacute;n: ${cre || "Invalida"}</p>
              <hr />
            `;
            div.addEventListener("contextmenu", (e) => mostrarOpciones(e, uid, u));
            listaUsuarios.appendChild(div);
          }
        }
        if (!listaUsuarios.hasChildNodes()) {
          listaUsuarios.innerHTML = "<p>No hay usuarios.</p>";
        }
      } else {
        listaUsuarios.innerHTML = "<p>No se encontraron usuarios.</p>";
      }
    }

    // ---------- MEN03 CONTEXTUAL ----------
    function mostrarOpciones(event, uid, usuario) {
      event.preventDefault();
      document.querySelectorAll(".menu-contextual").forEach(m => m.remove());
      const menu = document.createElement("div");
      menu.classList.add("menu-contextual");
      menu.innerHTML = `
        <button onclick="renovarCuenta('${uid}')">Renovar Cuenta</button>
        <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
        <button onclick="cambiarNumeroDispositivo('${uid}')">Cambiar # Dispositivos</button>
        <button onclick="cambiarContrasena('${uid}', '${usuario.password}')">Cambiar Contrase09a</button>
        <button onclick="restablecerContrasena('${usuario.email}')">Restablecer Contrase09a</button>
        <button onclick="copiarUsuario('${usuario.email}', '${usuario.password}')">Copiar Usuario</button>
        <button onclick="eliminarCuenta('${uid}')">Eliminar Cuenta</button>
      `;
      document.body.appendChild(menu);
      menu.style.top  = `${event.clientY}px`;
      menu.style.left = `${event.clientX}px`;
      document.addEventListener("click", () => menu.remove(), { once: true });
    }

    // ---------- RESTABLECER CONTRASE05A ----------
    async function restablecerContrasena(email) {
      if (!email) return alert("El usuario no tiene correo registrado.");
      try {
        await sendPasswordResetEmail(auth, email);
        alert(`Se envio un correo de restablecimiento a: ${email}`);
      } catch (err) {
        console.error(err);
        alert("No se pudo enviar el correo: " + (err.message || err));
      }
    }

    // ---------- RENOVAR CUENTA CON L07GICA DE FECHA ----------
    async function renovarCuenta(uid) {
      if (!await verificarLimiteDisponible()) {
        return alert("No tienes creditos disponibles para renovar la cuenta.");
      }
      try {
        // obtenemos ahora y la fecha de vencimiento actual desde la base
        const now = new Date(servidorFechaActual);
        let base = now;
        const vtoSnap = await get(ref(database, `usuarios/${uid}/benzymyentou`));
        if (vtoSnap.exists()) {
          const vtoStr = vtoSnap.val(); // formato "dd/mm/yyyy HH:mm:ss"
          const [d, m, anioHora] = vtoStr.split("/");
          const [anio, hora] = anioHora.split(" ");
          const fechaVto = new Date(`${anio}-${m}-${d}T${hora}`);
          if (fechaVto > now) {
            base = fechaVto;
          }
        }
        // sumamos un mes a la base calculada
        base.setMonth(base.getMonth() + 1);
        const nueva = 
          `${base.getDate().toString().padStart(2,"0")}/` +
          `${(base.getMonth()+1).toString().padStart(2,"0")}/` +
          `${base.getFullYear()} ` +
          `${base.getHours().toString().padStart(2,"0")}:` +
          `${base.getMinutes().toString().padStart(2,"0")}:` +
          `${base.getSeconds().toString().padStart(2,"0")}`;
        // descontamos el crdito y actualizamos
        if (!await actualizarLimiteUsuarios()) {
          return alert("No se pudo descontar cr\u00e9dito.");
        }
        await update(ref(database, `usuarios/${uid}`), { benzymyentou: nueva });
        alert(`Cuenta renovada. Nuevo vencimiento: ${nueva}`);
        cargarUsuarios();
      } catch (err) {
        console.error(err);
        alert("Error renovando cuenta.");
      }
    }

    // ---------- ELIMINAR DEVICE ID ----------
    async function eliminarDeviceID(uid) {
      try {
        await remove(ref(database, `usuarios/${uid}/deviceID`));
        alert("Device ID eliminado.");
        cargarUsuarios();
      } catch (err) {
        console.error(err);
        alert("Error al eliminar Device ID.");
      }
    }

    // ---------- CAMBIAR N03MERO DE DISPOSITIVO ----------
    async function cambiarNumeroDispositivo(uid) {
      const snap = await get(ref(database, `usuarios/${uid}/maxDevices`));
      let actual = parseInt(snap.val() || 0, 10);
      const n = parseInt(prompt(`Actual: ${actual}\nNuevo (<=3):`, actual), 10);
      if (isNaN(n) || n < actual || n > 3) {
        return alert("Nmero invlido.");
      }
      await update(ref(database, `usuarios/${uid}`), { maxDevices: n });
      alert("Nmero de dispositivos actualizado.");
      cargarUsuarios();
    }

    // ---------- CAMBIAR CONTRASE05A (con Firebase Admin) ----------
    async function cambiarContrasena(uid, currentPassword) {
      const nueva = prompt(
        `La contrase09a actual es: ${currentPassword}\nIngrese la nueva contrase09a:`,
        currentPassword
      );
      if (!nueva || !nueva.trim()) return;
      const nuevaTrim = nueva.trim();
      try {
        // Llamamos al endpoint de Firebase Admin para cambiar la contrase09a real
        const response = await fetch("/api/changePassword", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ uid, newPassword: nuevaTrim })
        });
        const data = await response.json();
        if (!data.success) {
          throw new Error(data.error || "Error al cambiar contrase09a");
        }
        // Actualizamos tambin en Realtime Database
        await update(ref(database, `usuarios/${uid}`), { password: nuevaTrim });
        alert("Contrase09a cambiada correctamente.");
        cargarUsuarios();
      } catch (err) {
        console.error(err);
        alert("Error al cambiar contrase09a: " + (err.message || "Sin descripcin"));
      }
    }

    // ---------- COPIAR USUARIO ----------
    function copiarUsuario(email, password) {
      navigator.clipboard
        .writeText(`Correo: ${email}\nContrase09a: ${password}`)
        .then(() => alert("Usuario copiado al portapapeles."))
        .catch(() => alert("Error al copiar."));
    }

    // ---------- ELIMINAR CUENTA ----------
    async function eliminarCuenta(uid) {
      if (!confirm("07Ests seguro de eliminar la cuenta?")) return;
      await remove(ref(database, `usuarios/${uid}/email`));
      alert("Usuario eliminado.");
      cargarUsuarios();
    }

    // ---------- FILTRO POR CORREO ----------
    buscarCorreo.addEventListener("input", () => {
      const f = buscarCorreo.value.toLowerCase();
      document.querySelectorAll(".usuario").forEach(u => {
        const mail = u.querySelector("p").textContent.toLowerCase();
        u.style.display = mail.includes(f) ? "" : "none";
      });
    });

    // Exponer globalmente
    window.renovarCuenta            = renovarCuenta;
    window.eliminarDeviceID         = eliminarDeviceID;
    window.cambiarNumeroDispositivo = cambiarNumeroDispositivo;
    window.cambiarContrasena        = cambiarContrasena;
    window.restablecerContrasena    = restablecerContrasena;
    window.copiarUsuario            = copiarUsuario;
    window.eliminarCuenta           = eliminarCuenta;
  </script>
</body>
</html>
