import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import { getDatabase, ref, get, update, remove } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

// Configuración de Firebase
const firebaseConfig = {
    apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
    authDomain: "magmaplus-32a56.firebaseapp.com",
    databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
    projectId: "magmaplus-32a56",
    storageBucket: "magmaplus-32a56.firebaseapp.com",
    messagingSenderId: "887768250224",
    appId: "1:63456783638:android:1e18d5484b58fc1411f437"
};

const app = initializeApp(firebaseConfig);
const database = getDatabase(app);

const listaUsuarios = document.getElementById("listaUsuarios");
const buscarCorreo = document.getElementById("buscarCorreo");

// Variable para el timer del long press en dispositivos táctiles
let touchTimer = null;

// Se carga la lista de usuarios automáticamente (panel de admin general)
cargarUsuarios();

// Función para convertir una cadena de fecha (sin comas) al formato deseado
function convertirFecha(fechaStr) {
    try {
        const [dia, mes, anioHora] = fechaStr.split("/");
        const [anio, hora] = anioHora.split(" ");
        const fechaISO = `${anio}-${mes}-${dia}T${hora}`;
        const fecha = new Date(fechaISO);
        if (isNaN(fecha.getTime())) throw new Error("Formato inválido");
        return `${fecha.getDate().toString().padStart(2, "0")}/${(fecha.getMonth() + 1)
            .toString()
            .padStart(2, "0")}/${fecha.getFullYear()} ${fecha
            .getHours()
            .toString()
            .padStart(2, "0")}:${fecha.getMinutes().toString().padStart(2, "0")}:${fecha
            .getSeconds()
            .toString()
            .padStart(2, "0")}`;
    } catch {
        return null;
    }
}

// Función que carga todos los usuarios, obtiene el correo del admin asociado y los muestra en pantalla
async function cargarUsuarios() {
    const usuariosRef = ref(database, "usuarios");
    const snapshot = await get(usuariosRef);

    if (snapshot.exists()) {
        const usuarios = snapshot.val();
        listaUsuarios.innerHTML = "";

        for (const uid in usuarios) {
            const usuario = usuarios[uid];
            // Se obtiene el correo del admin utilizando el campo "idv"
            let adminEmail = "No disponible";
            if (usuario.idv) {
                try {
                    // Primero, se busca en la sección "Admin"
                    let adminRef = ref(database, `Admin/${usuario.idv}`);
                    let adminSnapshot = await get(adminRef);
                    if (adminSnapshot.exists()) {
                        const adminData = adminSnapshot.val();
                        adminEmail = adminData.email || "No disponible";
                    } else {
                        // Si no se encuentra en "Admin", se busca en "Superadmin"
                        adminRef = ref(database, `Superadmin/${usuario.idv}`);
                        adminSnapshot = await get(adminRef);
                        if (adminSnapshot.exists()) {
                            const adminData = adminSnapshot.val();
                            adminEmail = adminData.email || "No disponible";
                        }
                    }
                } catch (error) {
                    console.error("Error al obtener el correo del admin:", error);
                }
            }

            const usuarioDiv = document.createElement("div");
            usuarioDiv.classList.add("usuario");

            const fechaCreacion = convertirFecha(usuario.creacion);
            const fechaVencimiento = convertirFecha(usuario.benzymyentou);

            usuarioDiv.innerHTML = `
                <p>Correo: ${usuario.email || "No disponible"}</p>
                <p>Vencimiento: ${fechaVencimiento || "Fecha inválida"}</p>
                <p>Contraseña: ${usuario.password}</p>
                <p>Creación: ${fechaCreacion || "Fecha inválida"}</p>
                <p>Admin: ${adminEmail}</p>
                <hr />
            `;
            // Evento para desktop: click derecho (contextmenu)
            usuarioDiv.addEventListener("contextmenu", (e) => {
                e.preventDefault();
                mostrarOpciones(e, uid, usuario);
            });
            // Eventos para dispositivos táctiles: long press
            usuarioDiv.addEventListener("touchstart", (e) => {
                touchTimer = setTimeout(() => {
                    mostrarOpciones(e, uid, usuario);
                }, 600);
            });
            usuarioDiv.addEventListener("touchend", (e) => {
                clearTimeout(touchTimer);
            });
            listaUsuarios.appendChild(usuarioDiv);
        }

        if (listaUsuarios.innerHTML === "") {
            listaUsuarios.innerHTML = "<p>No se encontraron usuarios con correo electrónico.</p>";
        }
    } else {
        listaUsuarios.innerHTML = "<p>No se encontraron usuarios en la base de datos.</p>";
    }
}

// Función que muestra el menú contextual cerca del puntero o toque, usando position: fixed
function mostrarOpciones(e, uid, usuario) {
    // Eliminar cualquier menú contextual previamente abierto
    document.querySelectorAll(".menu-contextual").forEach(menu => menu.remove());

    let x = 0, y = 0;
    if (e.type.startsWith("touch") && e.touches && e.touches.length > 0) {
        x = e.touches[0].clientX;
        y = e.touches[0].clientY;
    } else {
        x = e.clientX;
        y = e.clientY;
    }

    const menu = document.createElement("div");
    menu.classList.add("menu-contextual");
    // Establecer posición fija para que siempre aparezca en relación al viewport
    menu.style.position = "fixed";
    menu.innerHTML = `
        <button onclick="renovarCuenta('${uid}', '${usuario.benzymyentou}')">Renovar Cuenta</button>
        <button onclick="eliminarDeviceID('${uid}')">Reiniciar Device ID</button>
        <button onclick="copiarUsuario('${usuario.email}', '${usuario.password}')">Copiar Usuario Creado</button>
        <button onclick="eliminarCuenta('${uid}')">Eliminar Cuenta</button>
        <button onclick="cambiarNumeroDispositivos('${uid}')">Cambiar Número De Dispositivos</button>
    `;
    // Posicionar el menú en la ubicación del puntero/touch
    menu.style.left = x + "px";
    menu.style.top = y + "px";
    document.body.appendChild(menu);

    // Ajustar la posición si el menú se sale del viewport
    setTimeout(() => {
        const menuWidth = menu.offsetWidth;
        const menuHeight = menu.offsetHeight;
        const viewportWidth = window.innerWidth;
        const viewportHeight = window.innerHeight;

        if (x + menuWidth > viewportWidth) {
            x = viewportWidth - menuWidth - 10;
        }
        if (y + menuHeight > viewportHeight) {
            y = viewportHeight - menuHeight - 10;
        }
        menu.style.left = x + "px";
        menu.style.top = y + "px";
    }, 0);

    // Remover el menú si se hace clic fuera de este
    document.addEventListener("click", () => menu.remove(), { once: true });
}

// Función para renovar la cuenta: suma 1 mes a la fecha actual y actualiza el campo 'benzymyentou'
async function renovarCuenta(uid, vencimientoActual) {
    try {
        const vencimientoLimpio = vencimientoActual.replace(",", "");
        const [dia, mes, anioHora] = vencimientoLimpio.split("/");
        const [anio, hora] = anioHora.split(" ");
        const fechaActual = new Date(`${anio}-${mes}-${dia}T${hora}`);
        if (isNaN(fechaActual.getTime())) {
            throw new Error("Fecha de vencimiento inválida.");
        }
        // Se suma 1 mes a la fecha actual
        fechaActual.setMonth(fechaActual.getMonth() + 1);
        const nuevaFecha = `${fechaActual.getDate().toString().padStart(2, "0")}/${(fechaActual.getMonth() + 1)
            .toString()
            .padStart(2, "0")}/${fechaActual.getFullYear()} ${fechaActual
            .getHours()
            .toString()
            .padStart(2, "0")}:${fechaActual.getMinutes().toString().padStart(2, "0")}:${fechaActual
            .getSeconds()
            .toString()
            .padStart(2, "0")}`;
        const usuarioRef = ref(database, `usuarios/${uid}`);
        await update(usuarioRef, { benzymyentou: nuevaFecha });
        alert(`Cuenta renovada. Nuevo vencimiento: ${nuevaFecha}`);
        cargarUsuarios();
    } catch (error) {
        console.error("Error al renovar cuenta:", error.message);
        alert("No se pudo renovar la cuenta. Verifica el formato de la fecha.");
    }
}

// Función para eliminar el device ID del usuario
async function eliminarDeviceID(uid) {
    try {
        const deviceIDRef = ref(database, `usuarios/${uid}/deviceID`);
        await remove(deviceIDRef);
        alert("Device ID eliminado exitosamente.");
        cargarUsuarios();
    } catch (error) {
        console.error("Error al eliminar Device ID:", error);
        alert("No se pudo eliminar el Device ID. Intenta de nuevo.");
    }
}

// Función para copiar (al portapapeles) el correo y contraseña del usuario
function copiarUsuario(email, password) {
    const texto = `Correo: ${email}\nContraseña: ${password}`;
    const textarea = document.createElement("textarea");
    textarea.value = texto;
    document.body.appendChild(textarea);
    textarea.select();
    if (document.execCommand("copy")) {
        alert("Usuario copiado al portapapeles.");
    } else {
        alert("Error al intentar copiar el contenido. Verifica que el navegador permita el acceso al portapapeles.");
    }
    document.body.removeChild(textarea);
}

// Función para eliminar completamente la cuenta del usuario
async function eliminarCuenta(uid) {
    if (confirm("¿Estás seguro de que deseas eliminar la cuenta? Esta acción eliminará todos los datos del usuario.")) {
        try {
            const usuarioRef = ref(database, `usuarios/${uid}`);
            await remove(usuarioRef);
            alert("Cuenta eliminada exitosamente.");
            cargarUsuarios();
        } catch (error) {
            console.error("Error al eliminar cuenta:", error);
            alert("No se pudo eliminar la cuenta. Intenta de nuevo.");
        }
    }
}

// Función para cambiar el número de dispositivos permitidos
async function cambiarNumeroDispositivos(uid) {
    try {
        const usuarioRef = ref(database, `usuarios/${uid}`);
        const snapshot = await get(usuarioRef);
        
        if (snapshot.exists()) {
            const usuario = snapshot.val();
            const maxDevicesActual = usuario.maxDevices || 1;
            
            let nuevoMaxDevices = prompt(`Número actual de dispositivos: ${maxDevicesActual}\nIngrese el nuevo número de dispositivos (máximo 3):`, maxDevicesActual);
            
            // Validar entrada
            nuevoMaxDevices = parseInt(nuevoMaxDevices);
            if (isNaN(nuevoMaxDevices) || nuevoMaxDevices < 1) {
                alert("Por favor ingrese un número válido mayor o igual a 1.");
                return;
            }
            
            if (nuevoMaxDevices > 3) {
                alert("El número máximo de dispositivos permitidos es 3.");
                nuevoMaxDevices = 3;
            }
            
            // Actualizar en la base de datos
            await update(usuarioRef, { maxDevices: nuevoMaxDevices });
            alert(`Número de dispositivos actualizado a: ${nuevoMaxDevices}`);
            cargarUsuarios();
        } else {
            alert("No se encontró el usuario en la base de datos.");
        }
    } catch (error) {
        console.error("Error al cambiar el número de dispositivos:", error);
        alert("No se pudo cambiar el número de dispositivos. Intenta de nuevo.");
    }
}

// Hacer que las funciones sean accesibles globalmente (para poder ser llamadas desde los botones del menú contextual)
window.renovarCuenta = renovarCuenta;
window.eliminarDeviceID = eliminarDeviceID;
window.copiarUsuario = copiarUsuario;
window.eliminarCuenta = eliminarCuenta;
window.cambiarNumeroDispositivos = cambiarNumeroDispositivos;

// Filtrar usuarios por correo electrónico en tiempo real
buscarCorreo.addEventListener("input", () => {
    const filtro = buscarCorreo.value.toLowerCase();
    const usuarios = document.querySelectorAll(".usuario");
    usuarios.forEach((usuario) => {
        const correo = usuario.querySelector("p:first-child").textContent.toLowerCase();
        usuario.style.display = correo.includes(filtro) ? "" : "none";
    });
});