import { initializeApp } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js";
import { getDatabase, ref, get, update, remove } from "https://www.gstatic.com/firebasejs/10.7.1/firebase-database.js";

// Configuración de Firebase
const firebaseConfig = {
    apiKey: "AIzaSyCA1bpTEY7H7P47cgcCIS3DtLR64KxMxsk",
    authDomain: "magmaplus-32a56.firebaseapp.com",
    databaseURL: "https://magmaplus-32a56-default-rtdb.firebaseio.com",
    projectId: "magmaplus-32a56",
    storageBucket: "magmaplus-32a56.firebasestorage.app",
    messagingSenderId: "887768250224",
    appId: "1:63456783638:android:1e18d5484b58fc1411f437"
};

const app = initializeApp(firebaseConfig);
const database = getDatabase(app);

const listaUsuarios = document.getElementById("listaUsuarios");
const buscarCorreo = document.getElementById("buscarCorreo");

// Variable para el timer del long press en dispositivos táctiles
let touchTimer = null;

// Cargar la lista de usuarios de las secciones "Admin" y "Superadmin"
cargarUsuarios();

// Función para buscar información de admin por UID en toda la base de datos
async function buscarAdminPorUID(uid) {
    // Lista de nodos donde buscar
    const nodos = ["Admin", "Superadmin", "Usuarios", "Vendedor"];
    
    for (const nodo of nodos) {
        try {
            // Obtener todos los datos del nodo
            const snapshot = await get(ref(database, nodo));
            if (snapshot.exists()) {
                const data = snapshot.val();
                // Si el UID coincide directamente con una clave en el nodo
                if (data[uid] && data[uid].email) {
                    return data[uid].email;
                }
            }
        } catch (error) {
            console.error(`Error al buscar admin en ${nodo}:`, error);
        }
    }
    
    return null;
}

async function cargarUsuarios() {
    listaUsuarios.innerHTML = "";
    let usuariosCombinados = [];

    // Obtener todos los registros de "Admin"
    const adminSnapshot = await get(ref(database, "Admin"));
    if (adminSnapshot.exists()) {
        const admins = adminSnapshot.val();
        for (const uid in admins) {
            usuariosCombinados.push({
                uid,
                ...admins[uid],
                node: "Admin"
            });
        }
    }

    // Obtener todos los registros de "Superadmin"
    const superadminSnapshot = await get(ref(database, "Superadmin"));
    if (superadminSnapshot.exists()) {
        const superadmins = superadminSnapshot.val();
        for (const uid in superadmins) {
            usuariosCombinados.push({
                uid,
                ...superadmins[uid],
                node: "Superadmin"
            });
        }
    }

    // Iterar sobre el arreglo combinado
    for (const usuario of usuariosCombinados) {
        // Si el registro tiene campo "idv", se busca el correo del vendedor en el nodo "Vendedor"
        let vendedorEmail = null;
        if (usuario.idv) {
            try {
                const vendedorSnapshot = await get(ref(database, `Vendedor/${usuario.idv}`));
                if (vendedorSnapshot.exists()) {
                    const vendedorData = vendedorSnapshot.val();
                    vendedorEmail = vendedorData.email || null;
                }
            } catch (error) {
                console.error("Error al obtener información del vendedor:", error);
            }
        }
        
        // Buscar admin por UID
        let adminEmail = null;
        if (usuario.idv) {
            adminEmail = await buscarAdminPorUID(usuario.idv);
        }

        const usuarioDiv = document.createElement("div");
        usuarioDiv.classList.add("usuario");

        usuarioDiv.innerHTML = `
            <p>Email: ${usuario.email || "No disponible"}</p>
            <p>Creditos: ${usuario.limiteUsuarios || "0"}</p>
            ${vendedorEmail ? `<p>Vendedor: ${vendedorEmail}</p>` : ""}
            ${adminEmail ? `<p>Admin: ${adminEmail}</p>` : ""}
            <hr />
        `;

        // Asignar evento de click derecho (desktop)
        usuarioDiv.addEventListener("contextmenu", (e) => {
            e.preventDefault();
            mostrarOpciones(e, usuario.uid, usuario);
        });
        // Eventos para dispositivos táctiles: long press
        usuarioDiv.addEventListener("touchstart", (e) => {
            touchTimer = setTimeout(() => {
                mostrarOpciones(e, usuario.uid, usuario);
            }, 600);
        });
        usuarioDiv.addEventListener("touchend", (e) => {
            clearTimeout(touchTimer);
        });

        listaUsuarios.appendChild(usuarioDiv);
    }

    if (usuariosCombinados.length === 0) {
        listaUsuarios.innerHTML = "<p>No se encontraron usuarios.</p>";
    }
}

// Función que muestra el menú contextual con solo dos opciones: editar créditos y eliminar cuenta
function mostrarOpciones(e, uid, usuario) {
    // Eliminar cualquier menú contextual previamente abierto
    document.querySelectorAll(".menu-contextual").forEach(menu => menu.remove());

    let x = 0, y = 0;
    if (e.type.startsWith("touch") && e.touches && e.touches.length > 0) {
        x = e.touches[0].clientX;
        y = e.touches[0].clientY;
    } else {
        x = e.clientX;
        y = e.clientY;
    }

    const menu = document.createElement("div");
    menu.classList.add("menu-contextual");
    // Posición fija en relación al viewport
    menu.style.position = "fixed";
    menu.innerHTML = `
        <button onclick="editarCreditos('${uid}', '${usuario.node}', '${usuario.limiteUsuarios}')">Editar Creditos</button>
        <button onclick="eliminarCuenta('${uid}', '${usuario.node}')">Eliminar Cuenta</button>
    `;
    menu.style.left = x + "px";
    menu.style.top = y + "px";
    document.body.appendChild(menu);

    // Ajustar posición si el menú se sale del viewport
    setTimeout(() => {
        const menuWidth = menu.offsetWidth;
        const menuHeight = menu.offsetHeight;
        const viewportWidth = window.innerWidth;
        const viewportHeight = window.innerHeight;

        if (x + menuWidth > viewportWidth) {
            x = viewportWidth - menuWidth - 10;
        }
        if (y + menuHeight > viewportHeight) {
            y = viewportHeight - menuHeight - 10;
        }
        menu.style.left = x + "px";
        menu.style.top = y + "px";
    }, 0);

    // Remover el menú al hacer click fuera de él
    document.addEventListener("click", () => menu.remove(), { once: true });
}

// Función para editar los creditos (campo "limiteUsuarios") del usuario seleccionado
async function editarCreditos(uid, node, creditosActuales) {
    const nuevosCreditos = prompt("Editar creditos:", creditosActuales);
    if (nuevosCreditos !== null) {
        try {
            const usuarioRef = ref(database, `${node}/${uid}`);
            await update(usuarioRef, { limiteUsuarios: nuevosCreditos });
            alert("Creditos actualizados correctamente.");
            cargarUsuarios();
        } catch (error) {
            console.error("Error al actualizar creditos:", error);
            alert("No se pudo actualizar los creditos.");
        }
    }
}

// Función para eliminar la cuenta del usuario (elimina el registro del nodo correspondiente)
async function eliminarCuenta(uid, node) {
    if (confirm("¿Estás seguro de que deseas eliminar la cuenta? Esta acción eliminará todos los datos del usuario.")) {
        try {
            const usuarioRef = ref(database, `${node}/${uid}`);
            await remove(usuarioRef);
            alert("Cuenta eliminada exitosamente.");
            cargarUsuarios();
        } catch (error) {
            console.error("Error al eliminar cuenta:", error);
            alert("No se pudo eliminar la cuenta. Intenta de nuevo.");
        }
    }
}

// Filtrar usuarios por correo electrónico en tiempo real
buscarCorreo.addEventListener("input", () => {
    const filtro = buscarCorreo.value.toLowerCase();
    const usuarios = document.querySelectorAll(".usuario");
    usuarios.forEach((usuario) => {
        const correo = usuario.querySelector("p:first-child").textContent.toLowerCase();
        usuario.style.display = correo.includes(filtro) ? "" : "none";
    });
});

// Exponer funciones globalmente para poder ser llamadas desde los botones del menú contextual
window.editarCreditos = editarCreditos;
window.eliminarCuenta = eliminarCuenta;